/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Command;
import emulator.hardware.nmos6502.CommandSet;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.Operand;
import emulator.hardware.nmos6502.operands.Absolute;
import emulator.hardware.nmos6502.operands.AbsoluteX;
import emulator.hardware.nmos6502.operands.Accumulator;
import emulator.hardware.nmos6502.operands.ZeroPage;
import emulator.hardware.nmos6502.operands.ZeroPageX;

public class LSR
implements Command {
    @Override
    public void execute(Cpu6502 cpu, Operand operand) throws EmulatorException {
        HwByte value = operand.getByte();
        Flags6502 flags = cpu.getFlags();
        flags.setCarry(value.getBit(0));
        value.shift(-1);
        flags.setNZFromValue(value);
        operand.setByte(value);
        cpu.setFlags(flags);
    }

    @Override
    public String getName() {
        return "LSR";
    }

    @Override
    public void register(CommandSet cset) {
        cset.defineCommand(74, this, new Accumulator());
        cset.defineCommand(70, this, new ZeroPage(), 4);
        cset.defineCommand(86, this, new ZeroPageX(), 4);
        cset.defineCommand(78, this, new Absolute(), 4);
        cset.defineCommand(94, this, new AbsoluteX(false), 5);
    }
}

